/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.common.collect.AbstractIterator;
import io.github.fabricators_of_create.porting_lib.transfer.ViewOnlyWrappedIterator;
import io.github.fabricators_of_create.porting_lib.transfer.ViewOnlyWrappedStorageView;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.Iterator;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class ProcessingInventory
extends ItemStackHandlerContainer {
    public float remainingTime;
    public float recipeDuration;
    public boolean appliedRecipe;
    public Consumer<class_1799> callback;
    private boolean limit;

    public ProcessingInventory(Consumer<class_1799> callback) {
        super(16);
        this.callback = callback;
    }

    public ProcessingInventory withSlotLimit(boolean limit) {
        this.limit = limit;
        return this;
    }

    public int getSlotLimit(int slot) {
        return !this.limit ? super.getSlotLimit(slot) : 1;
    }

    public void clear() {
        this.setSize(this.getSlots());
        this.remainingTime = 0.0f;
        this.recipeDuration = 0.0f;
        this.appliedRecipe = false;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long inserted = super.insert(resource, maxAmount, transaction);
        if (inserted != 0L) {
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> this.callback.accept(resource.toStack((int)inserted)));
        }
        return inserted;
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10548("ProcessingTime", this.remainingTime);
        nbt.method_10548("RecipeTime", this.recipeDuration);
        nbt.method_10556("AppliedRecipe", this.appliedRecipe);
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.remainingTime = nbt.method_10583("ProcessingTime");
        this.recipeDuration = nbt.method_10583("RecipeTime");
        this.appliedRecipe = nbt.method_10577("AppliedRecipe");
        super.deserializeNBT(nbt);
        if (this.method_5442()) {
            this.appliedRecipe = false;
        }
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    public boolean isItemValid(int slot, ItemVariant resource, long amount) {
        return slot == 0 && this.method_5442();
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return new ViewOnlyWrappedIterator(super.iterator());
    }

    public Iterator<? extends StorageView<ItemVariant>> nonEmptyViews() {
        final Iterator original = super.nonEmptyViews();
        return new AbstractIterator<StorageView<ItemVariant>>(){

            @Nullable
            protected StorageView<ItemVariant> computeNext() {
                if (!original.hasNext()) {
                    return (StorageView)this.endOfData();
                }
                StorageView next = (StorageView)original.next();
                return new ViewOnlyWrappedStorageView(next);
            }
        };
    }
}

